/*
 * Project:     AJACS
 * File name:   test/Sieve.java
 * Purpose:     Eratosthenes Sieve prime number benchmark in Java
 * Author:      Boris Boesler
 * Modified by:
 * Created:     XX.08.2001
 * CVS-ID:      $Id: Sieve.java,v 1.12 2002/03/08 14:47:10 goetz Exp $
 * Copyright:   (c) 2001 Universitt Karlsruhe
 * Licence:     
 */


public class Sieve {
    static int SIZE = 500; //8190; 
    /* Gl: 8190 takes too long for continuous testing. */
  
  static void print_int(int i) {
  }

  public static void main(String[] argv) {
    int i;

    if (argv.length != 1) {
	AjacsIO.print("\nUsage: Sieve n\n");
	AjacsIO.print("Continuing with default input.\n");
    } else {
	SIZE = argv[0].atoi();
    }

    runSieve();
  }
  
  static void mark_count(int c) {
      AjacsIO.print("number of primes in [2..");
      AjacsIO.print(SIZE);
      AjacsIO.print(") : ");
      AjacsIO.print(c);
      AjacsIO.print(" (correct: 2..500: 95)\n");
  }

  static void runSieve() {
    int ITERATIONS = 100000;
    boolean[] flags = new boolean[SIZE];
    int i, prime, k, iter, p;
    int iterations = 0;
    int count;
    
    // loop around for measurements
    while(ITERATIONS > iterations) {
      for(i = 0; i < SIZE; i++)
	flags[i] = true;
      for(i = 2; i < SIZE; i++) {
	if(flags[i]) {
	  /* print_int(i); */
	  prime = i;
	  for(k = i + prime; k < SIZE; k += prime)
	    flags[k] = false;
	}
      }
      iterations++;
    }
    // test correctness
    count = 0;
    for(i = 2; i < SIZE; i++) {
      if(true == flags[i]) {
	count++;
      }
    }
    mark_count(count);
  }
}
