/*
 * Project:     AJACS
 * File name:   test/Quicksort.java
 * Purpose:     sorting with quicksort
 * Author:      
 * Modified by: Boris Boesler (for AJACS)
 * Created:     XX.11.2001
 * CVS-ID:      $Id: QuickSort.java,v 1.3 2002/03/08 14:47:10 goetz Exp $
 * Copyright:   (c) 2001 Universitt Karlsruhe
 * Licence:     
 * URL:         http://www-info1.informatik.uni-wuerzburg.de/staff/wolf/teaching/pi1_ws98/java/QuickSort.java
 */



public class QuickSort {
    
  // Variablen, in denen die Bewegungen und Vergleiche gespeichert werden
  private static int bewegungen;
  private static int vergleiche;
  
  //------------------------------
  // Hauptfunktion des Programmes
  //------------------------------
  public static void main(String[] args) { 
    int[] fld;
    
    // Speicher fuer fld erzeugen
    fld = new int[args.length];
    
    // Feldelemente belegen
    for( int i = 0; i < args.length; i++ )
      // fld[i] = Integer.parseInt( args[i] );
      fld[i] = args[i].atoi();

    AjacsIO.print("\n");
    if (args.length == 0) {
	AjacsIO.print("Usage: QuickSort <list of numbers>\n");
	AjacsIO.print("Continuing with default input.\n");
	// fld = new int[] {3, 18, 5, 99, 104, 2};
	fld = new int[6];
	fld[0] = 3; fld[1] = 18; fld[2] = 5; fld[3] = 99; fld[4] = 104; fld[5] = 2; 
    }
    
    AjacsIO.print("array:  ");
    for(int i = 0; i < fld.length; i++) {
      //System.out.print(b[i] + ",");
      AjacsIO.print(fld[i]);
      AjacsIO.print(", ");
    }

    // Sortieren
    bewegungen = 0;
    vergleiche = 0;
    quicksort( fld, 0, fld.length-1 );
    
    // Ausgabe
    AjacsIO.print( "\nSorted: " );
    
    for( int i = 0; i < fld.length; i++ ) {
      //System.out.print( fld[i] + "\t" );
      AjacsIO.print(fld[i]);
      AjacsIO.print(", ");
    }
    
    //System.out.print( "\nDazu wurden " + vergleiche );
    //System.out.print( " Vergleiche und " + bewegungen );
    //System.out.println( " Bewegungen benoetigt!" );
    AjacsIO.print("\nNeeded ");
    AjacsIO.print(vergleiche);
    AjacsIO.print(" comparisons and ");
    AjacsIO.print(bewegungen);
    AjacsIO.print(" moves.\n");
  }
  
  
  
  //--------------------
  // quicksort-Funktion
  //--------------------
  static void quicksort(int[] fld, int l, int r ) { 
    // Wenn der zu sortierende Teil eine Laenge <= 1 hat -> fertig
    if( l < r ) { 
      int pivot = fld[r];
      int i = l-1, j = r;
      
      // mit dem Pivotelement sortieren
      while( true ) { 
	while( fld[++i] < pivot )
	  vergleiche++;
	vergleiche++;
	
	while( j > l && fld[--j] > pivot )
	  vergleiche++;
	vergleiche++;
	// Wenn j <= i ist, wurde der zu sortierende Teil des Feldes
	// durchlaufen -> fertig
	if( j <= i )
	  break;
	
	// Elemente tauschen
	int v = fld[i];
	fld[i] = fld[j];
	fld[j] = v;
	// ein Tausch zweier Feldelemente wird als eine Bewegung gerechnet
	bewegungen++;
      }
      
      // Pivotelement in die Mitte tauschen
      fld[r] = fld[i];
      fld[i] = pivot;
      
      bewegungen++;
      
      // Die zwei Teilfolgen rekursiv mit quicksort sortieren
      quicksort( fld, l, i-1 );
      quicksort( fld, i+1, r );
    }
  }
}
