/*
 * Project:     AJACS
 * File name:   test/Queens.java
 * Purpose:     solve the queens problem
 * Author:      Markus Armbruster (in sather-k)
 * Modified by: Boris Boesler (for AJACS)
 * Created:     XX.11.2001
 * CVS-ID:      $Id: Queens.java,v 1.5 2002/03/18 15:59:35 boesler Exp $
 * Copyright:   (c) 2001 Universitt Karlsruhe
 * Licence:     
 */
/*
  -- The notorious n-queens problem (C.F. Gauss, 1850)
  -- Copyright (C) 1996 Markus Armbruster
*/

class Queens {

  private int[] row;
  // queen in column c is at row[c]
  
  static int abs(int i) {
    if(0 > i)
      i = -i;
    return(i);
  }
  
  boolean place_ok (int i) {
    // return whether queen in column i is
    // not in check from queens left of it
    int j = 0;
    boolean res;
    
    while (j < i) {
      if ((row[j] == row[i]) || ((abs(row[i]-row[j])) == (i-j))) {
	res = false;
	return(res);
      }
      j = j+1;
    }
    res = true;
    return(res);
  }
  
  int solve (int n) {
    // return the number of solutions to the n-queens problem
    int c = 0;
    int res = 0;

    row = new int[n];
    row[0] = -1;
    while (c >= 0) {
      row[c] = row[c]+1;
      while ((row[c] < n) && (!place_ok(c))) {
	row[c] = row[c]+1;
      }
      if (row[c] < n) { // successfully placed at (c,row[c])
	if (c == n-1)
	  res = res+1;
	else {
	  c = c+1;
	  row[c] = -1;
	}
      }
      else // dead end, track back
	c = c-1;
    }
    row = null;
    return(res);
  }
  
  static void usage (String progname) {
    AjacsIO.print("usage: ");
    AjacsIO.print(progname);
    AjacsIO.print(" [num]\n");
  }
  
  
  public static void main (String[] args) {
    Queens q = new Queens(); // stupid pitfall: can't use self, its void
    int n, res;
    
    switch(args.length()) {
    case 0:
      n = 8;
      break;
    case 1:
      n = args[0].atoi();
      break;
    default:
      usage("queens");
      res = 1;
      return;
    }
    // << "The " << n << "-queens problem has " << q.solve(n) << " solutions.\n";
    AjacsIO.print("The ");
    AjacsIO.print(n);
    AjacsIO.print("-queens problem has ");
    AjacsIO.print(q.solve(n));
    AjacsIO.print(" solutions.\n");
  }
  
}
