/*
 * Project:     AJACS
 * File name:   test/HeapSort.java
 * Purpose:     sorting with heapsort
 * Author:      
 * Modified by: Boris Boesler (for AJACS)
 * Created:     XX.11.2001
 * CVS-ID:      $Id: HeapSort.java,v 1.4 2002/05/03 15:48:19 boesler Exp $
 * Copyright:   (c) 2001 Universitt Karlsruhe
 * Licence:     
 * URL:         http://www-info1.informatik.uni-wuerzburg.de/staff/wolf/teaching/pi1_ws98/java/Heapsort.java
 * Bugs:        Fails for input 5,3,4,7,99
 */

/**
 * Heapsort-Algorithmus laut Vorlesung.
 */
public class HeapSort {
  
  /** Array mit Heap */
  int[] a;
  /** Gre des Heaps */
  int N;

  public static void print_int(int i) {
  }

  /**
   * Tauscht die Elemente a[i] und a[j].
   */
  void exchange(int i,int j) {
    int v;
    v = a[i];
    a[i] = a[j];
    a[j] = v;
 }
  
  /**
   * Lt a[k] im Feld aufsteigen.
   */
  void upheap(int k) {
    while ((k > 1) && (a[k] < a[k / 2])) {
      exchange(k, k / 2);
      k = k / 2;
    }
  }
  
  /**
   * Fgt das neue Element v in den Heap der Gre N
   * ein und erhht N um 1
   */
  void insert(int v) {
    N++;
    a[N] = v;
    upheap(N);
  }
 
 /**
  * Lt a[k] im Feld versickern.
  */
  void downheap(int k) {
    int j = 2 * k;
    if (j < N) {    // a[k] hat linken Sohn a[j]
      if (j + 1 < N)   // a[k] hat auch rechten Sohn a[j+1]
	if (a[j] > a[j + 1]) 
	  j++;        // Jetzt ist a[j] der kleinere Sohn von a[k]
      if (a[k] > a[j]) {
	exchange(k, j);
	downheap(j);
      }
    }
  }
  
  /**
   * Liefert als Resultat das Heap-Element a[k], entfernt a[k]
   * aus dem Heap und stellt die Heap-Eigenschaft wieder her.
   */
  int remove(int k) {
    int v = a[k];
    a[k] = a[N];
    N--;
    if ((k > 1) && (a[k] < a[k / 2])) 
      upheap(k);
    else
      downheap(k);
    return v;
  }
  
  /**
   * Aufbau des Heaps durch downheap.
   */
  void heapaufbau1() {
    for (int k = N / 2; k >= 1; k--) 
      downheap(k);
  }
  /**
   * Aufbau des Heaps durch insert.
   */
  void heapaufbau2() {
    int m = N; N = 0;
    for (int k = 1;k <= m; k++)
      insert(a[k]);
  }
  
  /**
   * Sortiert das gegebene Feld b mit den oben angegebenen 
   * Heap-Methoden und gibt das sortierte Feld zurck.
   */
  int[] heapsort(int[] b) {
    // Globale Variablen fr die Heap-Methoden setzen
    a = new int[b.length() + 1];
    N = a.length() - 1;
    // Die Heap-Methoden arbeiten auf dem Bereich a[1],...,a[N], 
    // normale Java-Array belegen aber b[0],...,b[b.length-1].
    for (int i = 0; i < b.length(); i++) {
      a[i + 1] = b[i];
    }
    heapaufbau2();
    // Ergebnis in c[] kopieren
    int[] c = new int[b.length()];
    for (int k = 0; k < c.length(); k++)
      c[k] = remove(1);
    return c;
  }
  
  /**
   * Ein einfaches Beispielprogramm. Alle Argumente des Programms mssen
   * Zahlen sein.
   * Bsp:<pre>
   * java Heapsort 6 13 17 42 9 3 5
   * array={6,13,17,42,9,3,5}
   * sorted array={3,5,6,9,13,17,42}
   * </pre>
   */
  public static void main (String[] args) {
    // Umwandeln der Argumente in Zahlen
    int[] b = new int[args.length()];

    AjacsIO.print("\n");
    
    for(int i = 0; i < b.length(); i++) {
      //b[i] = Integer.parseInt(args[i]);
      b[i] = args[i].atoi();
      AjacsIO.print(b[i]);
      AjacsIO.print("\n");
    }

    if (args.length() == 0) {
	AjacsIO.print("Usage: HeapSort <list of numbers>\n");
	AjacsIO.print("Continuing with default input.\n");
	// b = new int[] {3, 18, 5, 99, 104, 2};
	b = new int[6];
	b[0] = 3; b[1] = 18; b[2] = 5; b[3] = 99; b[4] = 104; b[5] = 2; 
    }

    // Ausgabe
    //System.out.print("array={");
    AjacsIO.print("array = ");
    for(int i = 0; i < b.length() - 1; i++) {
      //System.out.print(b[i] + ",");
      AjacsIO.print(b[i]);
      AjacsIO.print(", ");
    }
    if (b.length() > 0) {
      //System.out.print(b[b.length - 1]);
      AjacsIO.print(b[b.length() -1 ]);
    }
    //System.out.println("}");
    AjacsIO.print("\n");

    // Sortieren (wir bentigen dazu eine Instanz dieser Klasse)
    b = new HeapSort().heapsort(b);

    // Ausgabe
    //System.out.print("sorted array={");
    AjacsIO.print("sorted array = ");
    for(int i = 0; i < b.length() - 1; i++) {
      //System.out.print(b[i] + ",");
      AjacsIO.print(b[i]);
      AjacsIO.print(", ");
    }
    if (b.length() > 0) {
      //System.out.print(b[b.length - 1]);
      AjacsIO.print(b[b.length() - 1]);
    }
    //System.out.println("}");
    AjacsIO.print("\n");
  }
  
}
