/*
 * Project:     AJACS
 * File name:   test/Hanoi.java
 * Purpose:     Towers of hanoi
 * Author:      Arne Frick (in Sather-k)
 * Modified by: Boris Boesler (for Java)
 * Created:     XX.11.2001
 * CVS-ID:      $Id: Hanoi.java,v 1.3 2002/03/08 14:47:10 goetz Exp $
 * Copyright:   (c) 2001 Universitt Karlsruhe
 * Licence:     
 */


class PEGS {

  int[] stick;
  int moves;
  boolean verbose = false;
  
  void init(int n) {
    //-- initializes an array of pegs
    stick = new int[3];
    stick[0] = n;
    stick[1] = 0;
    stick[2] = 0;
    moves = 0;
  }
  
  void hanoi(int n, int from, int to) {
    int spare = 3 - from - to;
    if(n > 0) {
      //-- moves the stack of pegs from stick[from] via stick[temp]
      //-- to stick[to]
      
      hanoi (n-1, from, spare);
      ++moves;
      stick[from] = stick[from] - 1;
      stick[to] = stick[to] + 1;
      if (verbose) {
	//<< "move " << from << " to " << to << "\n";
      }
      hanoi (n-1, spare, to);
    }
  }
  
}

//--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

class Hanoi {

  public static void main(String[] args) {
    int i = 1;
    boolean n_specified = false;
    boolean verbose = false;
    
    int n;
    PEGS p;
    
    /*
      if args.asize > i  and  args[i].equals ("-v") {
      verbose = true;
      i = i + 1;
      }
    */
    AjacsIO.print("\n");
    if(1 != args.length()) {
      /*
	if i /= args.asize - 1 {
	<< " wrong # of arguments\n\n"
	"Usage: hanoi [-v] n\n"
	"   where n is the number of pegs\n"
	"   -v enables verbose printing of moves\n";
      */
	AjacsIO.print("Usage: hanoi n\nWhere n is the number of pegs.\nContinuing with default: n = 21 (-> 2097151)\n");
	n = 21;
    }
    else {
      n = args[0].atoi();
    }
    p = new PEGS();
    p.init (n);
    p.verbose = verbose;
    p.hanoi (n, 0, 2);
    //<< "Total #moves: " << p.moves << "\n";
    // hanoi(28) = 268435455
    AjacsIO.print("number of moves : ");
    AjacsIO.print(p.moves);
    AjacsIO.print("\n");    
  }
  
}
