/*
 * Project:     AJACS
 * File name:   AjacsIO.java
 * Purpose:     basic IO stubs
 * Author:      Boris Boesler
 * Modified by: G. Lindenmaier, T. Gaul
 * Created:     26.11.2001
 * CVS-ID:      $Id: AjacsIO.java,v 1.12 2002/06/10 12:35:31 boesler Exp $
 * Copyright:   (c) 2001 Universitt Karlsruhe
 * Licence:     
 */

public class AjacsIO {  

    /* 
     * Output to standard out.
     */
    public static native void print(int i);
    //public static native void print(long l);
    public static native void print(char c);
    public static native void print(float f);
    public static native void print(double d);    
    public static void print(String s) {
	for(int i = 0; i < s.length(); i++)
	    print(s.charAt(i));
    }
    /* 
     * Input from StdIn
     */
    public static native int  readint ();
    public static native char readchar ();

    /*
     * Opening and closing a file
     */    
    /* There is a ringbuffer of 10 C strings with 1024 chars length. 
       Get_emtpy_C_String initializes and returns the least recently
       used of these. */
    static native int  get_empty_C_String(int length);
    static native void append_char_to_C_String (int string_p, char c);
    static native void print_C_String (int CString);
    static int JavaStringToCString (String s) {
	int CString = get_empty_C_String(s.length()+1);      
	for (int i = 0; i < s.length(); i++) {
	    append_char_to_C_String (CString, s.charAt(i));
	}
	return CString;
    }
    static native int  fopen (int filename, int modes);
    static native int  fclose (int filehandle);
    /* Opens a file. */
    public static int FOpen (String filename, String modes) {
	return fopen( JavaStringToCString(filename),
		      JavaStringToCString(modes));
    }   
    public static int  FClose (int filehandle) {
	return fclose(filehandle);
    }

    /*public static native int getContentLength(int filehandle);*/

    /*
     *  Reading from a file.
     */
    static native char fgetc (int filehandle);
    public static char FGetC (int filehandle) {
	return fgetc(filehandle);
    }

    static native byte fgetb (int filehandle);
    public static byte FGetB (int filehandle) {
	return fgetb(filehandle);
    }

    static native int fread(byte[] array, int index, int num, int sif);

    /*
     *  File status info.
     */
    public static long FSize (String filename) {
	return filesize( JavaStringToCString(filename) );
    }

    public static int FMode (String filename) {
	return filemode( JavaStringToCString(filename) );
    }

    public static int FaTime (String filename) {
	return fileatime( JavaStringToCString(filename) );
    }

    public static int FcTime (String filename) {
	return filectime( JavaStringToCString(filename) );
    }

    public static int FmTime (String filename) {
	return filemtime( JavaStringToCString(filename) );
    }

    static native long filesize (int filename);
    static native int filemode (int filename);
    static native int fileatime (int filename);
    static native int filectime (int filename);
    static native int filemtime (int filename);


    /*
     *  The Timer.
     */
    public static native int currentTimeMillis ();

    // dummy main
    public static void main(String[] args) {
    }
}
