/*
 * Project:     AJACS
 * File name:   ajacslib.c
 * Purpose:     native routines
 * Author:      Boris Boesler
 * Modified by: G. Lindenmaier, T. Gaul
 * Created:     05.12.2001
 * CVS-ID:      $Id: ajacslib.c,v 1.14 2002/08/08 12:51:00 boesler Exp $
 * Copyright:   (c) 2001 Universitt Karlsruhe
 * Licence:     
 */

#include <ajacs_rt.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

/* get file infos: */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <sys/times.h>
#ifndef CLOCKS_PER_SEC
# define CLOCKS_PER_SEC 1000000L
#endif
#include <time.h>

/* DAS muss mal jemand richtig definieren, am besten in ajacs_rt: */

#define java_byte U8
#define java_char U16
#define java_int  S32
#define java_long S64   
#define java_float F32
#define java_double F64
#define java_pointer U32
#define java_String java_int


/*
 * support functions - could be generated by the compiler
 */
char *get_array_from_CoreByteArray(char *CoreByteArray)
{
  return(*((char**)(CoreByteArray + 12)));
}



/*
 * print funcions for all basic datatypes.
 */
void _AjacsIO_print_void_int(java_int i)
{  printf("%d", i); }
void _AjacsIO_print_void_long(java_long l)
{  printf("%lld", l); }
void _AjacsIO_print_void_float(java_float f)
{  printf("%1.9g", f); }
void _AjacsIO_print_void_double(java_double d)
{  printf("%1.18g", d); }
void _AjacsIO_print_void_char(java_char c)
{  printf("%c", c); }


static java_int i=-1;
static char buf[10][1024];

java_int _AjacsIO_get_empty_C_String_int_int(java_int length) {
    assert((length+1 < 1024) && "Can not convert Java strings longer than 1024 chars to C strings.");

    i++;    
    if (i>9) i=0;
    buf[i][0] = '\0';
    return i;    
}             

void _AjacsIO_append_char_to_C_String_void_int_char (java_int string_p, java_char c)
{
    sprintf((char*)&buf[string_p], "%s%c", buf[string_p], c);
}

void _AjacsIO_print_C_String_void_int (java_int CString) {
    printf("%s", buf[CString]);
}


/*
 * read an integer
 */
java_int _AjacsIO_readint_int()
{
    S32 buf;
    scanf("%d",&buf);
    // if != 1 throw exception ;-)
    return buf;
}

/*
 * read a c-char
 */
java_char _AjacsIO_readchar_char()
{
    char buf;
    scanf("%c",&buf);
    // if != 1 throw exception ;-)
    return (java_char)buf;
}

/*
 * open file
 */
java_int _AjacsIO_fopen_int_int_int(java_String filename, java_String modes)
{
    char *filename_str = (char *)&buf[filename];
    char *modes_str = (char *)&buf[modes];

    FILE* file = fopen(filename_str, modes_str); 

    if (file == 0) {
	printf(" ERROR opening file %s\n", filename_str);
	exit(0);
    }

    return (java_int) file;
}

/*
 * close file
 */
java_int _AjacsIO_fclose_int_int(java_int filehandle)
{
    FILE *file = (FILE *)filehandle;
    return (java_int) fclose(file);
}

/*
 * get char
 */
java_char _AjacsIO_fgetc_char_int(java_int filehandle)
{
  return (java_char)fgetc((FILE *)filehandle);
}

/*
 * get byte
 */
java_byte _AjacsIO_fgetb_byte_int(java_int filehandle)
{
  return (java_byte)fgetc((FILE *)filehandle);
}


/*
 * fill a byte array from a file
 */
java_int _AjacsIO_fread_int_CoreByteArray_int_int_int(char *CoreByteArray,
						      java_int index,
						      java_int num,
						      java_int sif)
{
  char *byte_array;
  java_int res;
  
  byte_array = get_array_from_CoreByteArray(CoreByteArray);
  byte_array += index;
  
  res = fread(byte_array, 1, num, (FILE*)sif);
  return(res);
}


java_int _AjacsIO_currentTimeMillis_int()
{
  return (java_int)(((long)clock()*1000L)/CLOCKS_PER_SEC);
}

struct stat AJACS_stat;

java_long _AjacsIO_filesize_long_int(java_String filename)
{
  char* filename_str = (char*) &buf[filename];

  /* puts(filename_str);  / * DEBUG */

  if (stat(filename_str,&AJACS_stat))
    {
      printf(" ERROR accessing file %s\n", filename_str);
      exit(0);
    }
  /* st_size might be 32 or 64 bit (on Linux), cast it to long int: */
  return (java_long) AJACS_stat.st_size;
}
  
java_int _AjacsIO_filemode_int_int(java_String filename)
{
  char* filename_str = (char*) &buf[filename];

  if (stat(filename_str,&AJACS_stat))
    {
      printf(" ERROR accessing file %s\n", filename_str);
      exit(0);
    }
  return (java_int) AJACS_stat.st_mode;
}
  
enum timode {ATIME=0, MTIME=1, CTIME=2};

java_int _AjacsIO_filextime_int_int_int(java_String filename, enum timode tim)
{
  char* filename_str = (char*) &buf[filename];
  int res = 0;

  if (stat(filename_str,&AJACS_stat))
    {
      printf(" ERROR accessing file %s\n", filename_str);
      exit(0);
    }
  switch (tim) {
  case ATIME: res = AJACS_stat.st_atime; break;
  case MTIME: res = AJACS_stat.st_mtime; break;
  case CTIME: res = AJACS_stat.st_ctime; break;
  }
  return (java_int) res;
}

java_int _AjacsIO_fileatime_int_int(java_String filename)
{  return _AjacsIO_filextime_int_int_int( filename, ATIME ); }

java_int _AjacsIO_filectime_int_int(java_String filename)
{  return _AjacsIO_filextime_int_int_int( filename, CTIME ); }

java_int _AjacsIO_filemtime_int_int(java_String filename)
{  return _AjacsIO_filextime_int_int_int( filename, MTIME ); }

