/*
 * Project:     AJACS
 * File name:   ajacs_rt.h
 * Purpose:     provide interface to AJACS runtime environment
 * Author:      Boris Boesler
 * Modified by:
 * Created:     25.01.2002
 * CVS-ID:      $Id: ajacs_rt.h,v 1.13 2002/08/26 13:53:13 boesler Exp $
 * Copyright:   (c) 2002 Universitt Karlsruhe
 * Licence:     
 */

#ifndef __AJACS_RT_H__
#define __AJACS_RT_H__

#include <stdlib.h>

#define __USE_ISOC99 1

#include <limits.h>
#include <float.h>

/* define types which qualify sign and size */

#if UCHAR_MAX == 255
typedef unsigned char U8;
#else
# error can not define unsigned 8 bit type
#endif
#if SCHAR_MAX == 127
typedef signed char S8;
#else
# error can not define signed 8 bit type
#endif
#if USHRT_MAX == 65535
typedef unsigned short U16;
#else
# if UINT_MAX == 65535
typedef unsigned int U16;
# else
#  error can not define unsigned 16 bit type
# endif
#endif
#if SHRT_MAX == 32767
typedef signed short S16;
#else
# if INT_MAX == 32767
typedef signed int S16;
# else
#  error can not define signed 16 bit type
# endif
#endif
#if UINT_MAX == 4294967295U
typedef unsigned int U32;
#else
# if ULONG_MAX == 4294967295U
typedef unsigned long U32;
# else
#  error can not define unsigned 32 bit type
# endif
#endif

#if INT_MAX == 2147483647
typedef signed int S32;
#else
# if LONG_MAX == 2147483647
typedef signed long S32;
# else
#  error can not define signed 32 bit type
# endif
#endif



/* GCC seems only to define __LONG_LONG_MAX__.  The others are defined 
   relative to this variable, e.g. ULONG_LONG_MAX = __LONG_LONG_MAX__ * 2 + 1 */
#if ((  LONG_MAX   == 9223372036854775807L) ||    \
     (__LONG_MAX__ == 9223372036854775807L)   ) 
typedef signed long S64;
typedef unsigned long U64;
#else
# if ((      LLONG_MAX   == 9223372036854775807LL) ||   \
      (  LONG_LONG_MAX   == 9223372036854775807LL) ||   \
      (__LONG_LONG_MAX__ == 9223372036854775807LL)   )
typedef signed long long S64;
typedef unsigned long long U64;
# else
#  error can not define unsigned 64 bit type
#  error can not define signed 64 bit type 
# endif
#endif

#if (FLT_MAX_10_EXP == 38)
typedef float F32;
# else
#  error can not define 32 bit floating point type
#endif

#if (DBL_MAX_10_EXP == 308)
typedef double F64;
# else
#  error can not define 64 bit floating point type
#endif

/* AJACS memory allocation */
#define AJACS_malloc(size,alignment) malloc(size)

/* how to place memory in ROM*/
#define AJACS_inROM const

/*
 * synchronisation in AJACS
 * v is a pointer to a 32 bit (Java integer) value
 */

#if 0
 this stuff is obsolete
/* AJACS locking for synchronisation */
#define AJACS_lock(v) printf("lock *(%x)\n", (unsigned)v);
/* AJACS unlocking for synchronisation */
#define AJACS_unlock(v) printf("unlock *(%x)\n", (unsigned)v);
#endif

#define AJACS_GetResource(_s_) _s_
#define AJACS_ReleaseResource(_s_) _s_

#endif
