 /* Copyright (c) 2001 by Florian Liekweg, IPD, Universitaet Karlsruhe.  All Rights Reserved */

/***
   NAME
     exceptions
   PURPOSE
     define some exception code and codes
   NOTES
     $Id: ajacs_exc.h,v 1.3 2002/08/14 13:20:25 boesler Exp $
   HISTORY
     liekweg - Jun 22, 2001: Created.
***/

#if !defined _EXCEPTIONS_H_
#define _EXCEPTIONS_H_

#include <setjmp.h>

/* exceeded types */
typedef struct _exc_env_t 
{
  jmp_buf _buf;
  struct _exc_env_t *_enc;
} exc_env_t;

typedef 	int		exc_t;

/* thread local exception infrastructure */
exc_env_t* 	exc_env = 0;
int		exc_code = 0;

# define push_exc_env()		do {					\
  exc_env_t *l_exc_env = 0;						\
  l_exc_env = (exc_env_t*) malloc (sizeof (exc_env_t));	                \
  l_exc_env->_enc = exc_env;						\
  exc_env  = l_exc_env;							\
  exc_code = setjmp (l_exc_env->_buf);					\
} while (0)

# define pop_exc_env()                                                  \
do {                                                                    \
  free (exc_env);                                                       \
  exc_env = exc_env->_enc;                                              \
} while (0)

# define throw()							\
do {									\
  longjmp (exc_env->_buf, ~0x00);					\
} while (0)

#endif /* not defined _EXCEPTIONS_H_ */
